#!/bin/bash

# path to Phenix installation is required
if [ "$#" -ne 1 ]; then
  echo \
'
Please provide the location of Phenix. For example, if your installation
is in /Applications/phenix-1.20.1-4487, your command should look like

./fix_wxpython.sh /Applications/phenix-1.20.1-4487

If your installation is in a restricted directory like /Applications,
prepend the "sudo" command. For example, the commanda above becomes

sudo ./fix_wxpython.sh /Applications/phenix-1.20.1-4487
'
  exit 1
fi

phenix=$1

# check for conda_base
if [ ! -d ${phenix} ] || [ ! -d ${phenix}/conda_base ]; then
  echo "
The directory, ${phenix}/conda_base, does not exist.
Please provide a valid Phenix installation directory.
"
  exit 1
fi

conda_base=${phenix}/conda_base

# remove existing wxPython
echo "Removing old version of wxPython"
echo "================================"
./bin/conda.exe remove -p ${conda_base} -y --force wxpython
echo ""

# install new wxPython
echo "Installing new version of wxPython"
echo "=================================="
./bin/conda.exe install -p ${conda_base} -y --no-deps ./pkgs/wxpython-3.0.2.0-py27hca0af0f_2.tar.bz2
echo ""

# finalize
echo "The wxPython package has been updated in ${phenix}."
