from __future__ import division
from libtbx import easy_run

def run_polder(pdb_code, selection):
  cmd = " ".join([
    "phenix.polder",
    "%s.pdb" % pdb_code,
    "%s.mtz" % pdb_code,
    "sphere_radius=5",
    'output_file_name_prefix="%s" ' %pdb_code,
    'solvent_exclusion_mask_selection="%s" ' % selection,
    "> %s_polder.log" % pdb_code
  ])
  print cmd
  easy_run.call(cmd)

def run_babinet(pdb_code):
  cmd = " ".join([
    "python run_babinet.py",
    "%s_omit_MES.pdb" % pdb_code,
    "%s.mtz" % pdb_code,
    "> %s_babinet.log" % pdb_code
  ])
  print cmd
  easy_run.call(cmd)

def run_lowres(pdb_code):
  cmd = " ".join([
    "python run_truncate_low_res_2.py",
    "%s_omit_MES.pdb" % pdb_code,
    "%s.mtz" % pdb_code,
    "> %s_lowres.log" % pdb_code
  ])
  print cmd
  easy_run.call(cmd)


run_polder(
	pdb_code = '1aba',
	selection = 'chain A and resseq 88')

run_babinet(pdb_code = '1aba')

run_lowres(pdb_code = '1aba')

easy_run.call('phenix.mtz2map 1aba_polder_map_coeffs.mtz')
easy_run.call('phenix.mtz2map babinet_map_coeffs.mtz')
easy_run.call('phenix.mtz2map low_res_map_coeffs.mtz')
