#---------------
# load map and select
#---------------
load 1aba.pdb
select MES88, chain A and resi 88
#show cartoon,
show sticks, MES88
hide lines
hide nonbonded,
bg_color white
center MES88
#---------------
# map settings
#---------------
set mesh_width,0.35
set mesh_radius,0.001 #0.012
#---------------
# performance
#---------------
set direct,1.
set orthoscopic,on
set ray_trace_fog_start,0.5
util.performance(0)
util.ray_shadows('light')
cmd.space('cmyk')
set antialias,on
#------------
# load maps
#------------
load 1aba_polder_map_coeffs_1.ccp4
load babinet_map_coeffs_1.ccp4
load low_res_map_coeffs_2.ccp4
load 1aba_polder_map_coeffs_2.ccp4
#---------
# set view
#---------
set_view (\
    -0.417035162,   -0.640507400,   -0.644847095,\
    -0.373803318,    0.767577827,   -0.520665586,\
     0.828459561,    0.023908079,   -0.559530079,\
    -0.000360789,   -0.000211653,  -27.074796677,\
    -1.033107758,   45.910747528,   50.061691284,\
    17.161979675,   37.007965088,  -20.000000000 )
#-------------------------
# draw mesh and save pics
#-------------------------
isomesh polder, 1aba_polder_map_coeffs_1, 3.0, MES88, carve=8
isomesh polder_neg, 1aba_polder_map_coeffs_1, -3.0, MES88, carve=8
cmd.color(22,"polder")
cmd.color(4,"polder_neg")
ray
cmd.png('''/Users/dcliebschner/Desktop/figure8_polder3s.png''',quiet=0)
cmd.disable('polder')
cmd.disable('polder_neg')
#-----
isomesh omit, 1aba_polder_map_coeffs_2, 3.0, MES88, carve=8
isomesh omit_neg, 1aba_polder_map_coeffs_2, -3.0, MES88, carve=8
cmd.color(22,"omit")
cmd.color(4,"omit_neg")
ray
cmd.png('''/Users/dcliebschner/Desktop/figure8_omit3s.png''',quiet=0)
cmd.disable('omit')
cmd.disable('omit_neg')
#-----
isomesh omit2, 1aba_polder_map_coeffs_2, 2.0, MES88, carve=8
isomesh omit2_neg, 1aba_polder_map_coeffs_2, -2.0, MES88, carve=8
cmd.color(22,"omit2")
cmd.color(4,"omit2_neg")
ray
cmd.png('''/Users/dcliebschner/Desktop/figure8_omit2s.png''',quiet=0)
cmd.disable('omit2')
cmd.disable('omit2_neg')
#-----
isomesh babinet, babinet_map_coeffs_1, 3.0, MES88, carve=8
isomesh babinet_neg, babinet_map_coeffs_1, -3.0, MES88, carve=8
cmd.color(22,"babinet")
cmd.color(4,"babinet_neg")
ray
cmd.png('''/Users/dcliebschner/Desktop/figure8_babinet3s.png''',quiet=0)
cmd.disable('babinet')
cmd.disable('babinet_neg')
#-----
isomesh babinet2, babinet_map_coeffs_1, 2.0, MES88, carve=8
isomesh babinet2_neg, babinet_map_coeffs_1, -2.0, MES88, carve=8
cmd.color(22,"babinet2")
cmd.color(4,"babinet2_neg")
ray
cmd.png('''/Users/dcliebschner/Desktop/figure8_babinet2s.png''',quiet=0)
cmd.disable('babinet2')
cmd.disable('babinet2_neg')
#-----
isomesh lowres, low_res_map_coeffs_2, 3.0, MES88, carve=8
isomesh lowres_neg, low_res_map_coeffs_2, -3.0, MES88, carve=8
cmd.color(22,"lowres")
cmd.color(4,"lowres_neg")
ray
cmd.png('''/Users/dcliebschner/Desktop/figure8_lowres3s.png''',quiet=0)
cmd.disable('lowres')
cmd.disable('lowres_neg')
#-----
isomesh lowres2, low_res_map_coeffs_2, 2.0, MES88, carve=8
isomesh lowres2_neg, low_res_map_coeffs_2, -2.0, MES88, carve=8
cmd.color(22,"lowres2")
cmd.color(4,"lowres2_neg")
ray
cmd.png('''/Users/dcliebschner/Desktop/figure8_lowres2s.png''',quiet=0)
cmd.save('''/Users/dcliebschner/Desktop/figure8.pse''',quiet=0)
