# -*- coding: utf-8 -*-

from __future__ import division, print_function
import os,sys

def run(args):
  if len(args) != 2:
    print("Use: phenix.python compare_ca.py file1.pdb file2.pdb")
    return
  file_name = args[0]
  other_file_name = args[1]
  from iotbx.data_manager import DataManager
  dm = DataManager()
  m1 = dm.get_model(file_name)
  m2 = dm.get_model(other_file_name)
  m1_ca_sc = m1.apply_selection_string('name ca').get_sites_cart()
  m2_ca_sc = m2.apply_selection_string('name ca').get_sites_cart()
  if m1_ca_sc.size() != m2_ca_sc.size():
    print("Models do not have same number of CA atoms")
    return
  diffs = m1_ca_sc - m2_ca_sc
  rmsd = diffs.rms_length()
  print("RMSD: %.3f" %rmsd)

if __name__=="__main__":
  run(sys.argv[1:])
