# THis one...all solutions , just as is, read in resolution and scoring table
"""
DIR MAD/aep/run_020808_scoring_c
DATAFILE:  AutoSol_run_1_/infl_PHX.sca_1 None
DATAFILE:  AutoSol_run_1_/peak_PHX.sca_1 None
DATAFILE:  AutoSol_run_1_/high_PHX.sca_1 None
ANISO_B_MIN:  None
Number of scoring criteria:  10
 RESOLUTION: 2.5
Solution 1 AutoSol_run_1_ Z_SCORE: 19.6807 CC_TO_PERFECT: 0.0365 INVERSE: 2 RESOLUTION: 2.5
 NAME CC RFACTOR SKEW NCS_OVERLAP NCS_COPIES NCS_IN_GROUP TRUNCATE REGIONS SD FOM
 RAW 0.267 0.5769 0.0041 0.0 0.0 0.0 0.6576 1.8823 0.049 0.78
 ZSCORE 0.7825 2.3035 0.9947 0.0 0.0 0.0 1.4169 -0.6764 6.6281 15.6
 MEAN 0.263676766667 0.580642566667 -1.743441e-05 0.0 0.0 0.0 0.6563796 1.866985 0.045857325 0.0
 SD 0.00425238816557 0.00161535565826 0.00409766269371 0.02 0.02 0.02 0.000827498360123 0.0226678162248 0.000468166887049 0.05
 RESOLUTION: 2.5

"""
import sys,os
#
score_type_keep=['RFACTOR','SKEW', 'CC', 'FOM']
score_type_keep=['ALL']
square=sys.argv[1]
print "Square: ",square
if square.lower().find("square")>-1:
  square="CC_SQUARE_"
  print "Squaring perfect_cc"
else:
  square=""
  print "Not Squaring perfect_cc"
print "Square: ",square
verbose=True
b_dict={}
res_dict={}
bfile='read_res.list'
for line in open(bfile).readlines():
  spl=line.split()
  if len(spl)<3: continue
  names=spl[0].replace("\n","").replace("//","/").replace(" ","")
  if names[-1]=="/":names=names[:-1]
  name=names.split("/")[-2]
  b_dict[name]=float(spl[1]) 
  res_dict[name]=float(spl[1]) 

print "B_DICT: ",b_dict
print "R_DICT: ",res_dict

file="all_res_table.dat"
print "Analyzing data in ",file
all_data_raw={}
all_data_mean={}
all_data_sd={}
all_data_z_score={}
all_data_resolution={}
all_data_b={}
all_data_overall_z={}
all_data_perfect_cc={}
score_type_list=[]
run_data={}
run_name=None
solution_name=None
solution_data={}

solution_name=None
types=None
raw_scores=None
mean_scores=None
sd_scores=None
z_scores=None
b=None

for line in open(file).readlines():
  if not line: continue
  if not line.split(): continue
  if line.split()[0]=="DIR" and len(line.split())>1:
     run_name=line.split()[1]
     #print "New run: ",run_name
     run_data_sd={}
     all_data_sd[run_name]=run_data_sd
     run_data_mean={}
     all_data_mean[run_name]=run_data_mean
     run_data_raw={}
     all_data_raw[run_name]=run_data_raw
     run_data_z_score={}
     all_data_z_score[run_name]=run_data_z_score
     run_data_b={}
     all_data_b[run_name]=run_data_b
     run_data_resolution={}
     all_data_resolution[run_name]=run_data_resolution
     run_data_overall_z={}
     all_data_overall_z[run_name]=run_data_overall_z
     run_data_perfect_cc={}
     all_data_perfect_cc[run_name]=run_data_perfect_cc
     for key in b_dict.keys():
         if run_name.find(key)>-1:
           b=b_dict[key]
           #print "B: ",key,run_name,b
           #if found: print "DUPLICATE Name"
           break

  elif  line.split()[0]=="Solution" and len(line.split())>1:
     solution_name=line.split()[1]
     try:
       solution_z_score=float(line.split()[4])
       solution_perfect_cc=float(line.split()[6])
     except:
       solution_z_score=None
       solution_perfect_cc=None
     try:  # get resolution
       spl=line.split("RESOLUTION:")
       if len(spl)>1:
          resolution=float(spl[1])
     except:
       resolution=None
 
           

     #print "new solution: ",solution_name 
  elif  line.split()[0]=="NAME" and len(line.split())>1:
     types=line.split()[1:]
     if not score_type_list or len(score_type_list)<len(types):
          score_type_list=types
          print "SCORE TYPE LIST: ",score_type_list
  elif  line.split()[0]=="RAW" and len(line.split())>1:
     raw_scores=line.split()[1:]
  elif  line.split()[0]=="ZSCORE" and len(line.split())>1:
     z_scores=line.split()[1:]
  elif  line.split()[0]=="MEAN" and len(line.split())>1:
     mean_scores=line.split()[1:]
  elif  line.split()[0]=="SD" and len(line.split())>1:
     sd_scores=line.split()[1:]


  if solution_name and types and raw_scores and z_scores and\
       solution_z_score and solution_perfect_cc and mean_scores and sd_scores: 
    # new solution
    if resolution is not None and b is not None:
     solution_data_mean={}
     solution_data_sd={}
     solution_data_raw={}
     solution_data_z_score={}
     for type,raw_score,z_score,mean_score,sd_score in zip(
       types,raw_scores,z_scores,mean_scores,sd_scores):
       solution_data_sd[type]=sd_score
       solution_data_mean[type]=mean_score
       solution_data_raw[type]=raw_score
       solution_data_z_score[type]=z_score
     run_data_sd[solution_name]=solution_data_sd
     run_data_mean[solution_name]=solution_data_mean
     run_data_raw[solution_name]=solution_data_raw
     run_data_z_score[solution_name]=solution_data_z_score
     run_data_overall_z[solution_name]=solution_z_score
     run_data_resolution[solution_name]=resolution
     run_data_b[solution_name]=b
     run_data_perfect_cc[solution_name]=solution_perfect_cc
    solution_name=None
    types=None
    sd_scores=None
    mean_scores=None
    raw_scores=None
    z_scores=None

# analyze the data now:

run_list=all_data_raw.keys()
print "Total of ",len(run_list),"runs to analyze"
label="_res_table"
z_score_est_out=open('z_score_est'+label+'.dat','w')
raw_out_4=open(square+'raw_4'+label+'.list','w')
zscore_out_4=open(square+'zscore_4'+label+'.list','w')
print >>raw_out_4,"run solution perfect_cc"+square,
for score_type in score_type_list:
  print >> raw_out_4, score_type,
print >>raw_out_4
print >>zscore_out_4,"run solution perfect_cc"+square+" zscore",
for score_type in score_type_list:
  print >> zscore_out_4, score_type,
print >>zscore_out_4

for run in run_list:
#for run in ['MIR/pen/run_020208b_scoring']:
  if verbose:print "\nRUN ",run
  solution_data_sd=all_data_sd[run]
  solution_data_mean=all_data_mean[run]
  solution_data_raw=all_data_raw[run]
  solution_data_z_score=all_data_z_score[run]
  solution_data_overall_z=all_data_overall_z[run]
  solution_data_resolution=all_data_resolution[run]
  solution_data_b=all_data_b[run]
  solution_data_perfect_cc=all_data_perfect_cc[run]
  solution_list=solution_data_raw.keys()
  for solution in solution_list:
    perfect_cc=solution_data_perfect_cc[solution]

    data_sd=solution_data_sd[solution]
    data_mean=solution_data_mean[solution]
    data_raw=solution_data_raw[solution]
    data_z_score=solution_data_z_score[solution]
    overall_z=float(solution_data_overall_z[solution])
    resolution=float(solution_data_resolution[solution])
    b=float(solution_data_b[solution])
    if square:
       mult=perfect_cc
    else:
       mult=1.
    if verbose:print "\nSOLUTION ",solution," INVERSE: ","Z:",overall_z," CC:",perfect_cc
    print >>raw_out_4, run,solution,perfect_cc*mult,
    print >>zscore_out_4, run,solution,perfect_cc*mult,overall_z,
    sum_z_score=0. 
    for score_type in score_type_list:
       try:
         mean=float(data_mean[score_type])
       except: 
         mean=0.0

       try:
         sd=float(data_sd[score_type])
       except: 
         sd=0.0

       try:
         raw=float(data_raw[score_type])
       except: 
         raw=0.0

       try:
         z_score=float(data_z_score[score_type])
       except: 
         z_score=0.0

       if score_type in ["SKEW","CC"]:
         value=raw
         #value=raw-mean
       else:
         value=raw-mean  
       value=raw  #JUST HERE USING RAW
       if verbose:print score_type,raw,z_score
       print >>raw_out_4, value,
       print >>zscore_out_4, z_score,
       if score_type in score_type_keep or "ALL" in score_type_keep:
         sum_z_score+=z_score
    print >> z_score_est_out,run,perfect_cc,sum_z_score

    print >>raw_out_4, resolution,b
    print >>zscore_out_4, resolution,b
