from cctbx.array_family import flex
import math,sys,os


def cc_value(target_list,value_list):  # return correlation coefficient of 
   # 2 flex arrays   sum(x1-x1bar)(x2-x2bar)/sum(x1-x1bar)(x2-x2bar)
   c=flex.linear_correlation(target_list,value_list)
   n=float(len(target_list))
   msqr=math.sqrt(flex.sum_sq(target_list-value_list)/(n-1.))
   # NOTE msqr is rmsd of target from value
   return c.coefficient(),msqr

a=flex.double()
b=flex.double()
 

column_decide=3
column2=3
if len(sys.argv)<3:
  min=-1000.
  max=10000.
else: 
  min=float(sys.argv[2])
  max=float(sys.argv[3])
if len(sys.argv)==5:
    column2=int(sys.argv[4])
    column_decide=1
print "min max",min,max,"cols: ",1,column2
for line in open(sys.argv[1]).readlines():
      spl=line.split()
      if float(spl[column_decide])<min or float(spl[column_decide])>max: continue
      a.append(float(spl[1]))
      b.append(float(spl[column2]))
cc,msqr=cc_value(a,b)
print "SCORE :",cc," RMSD ",msqr
 
   
