import sys
def try_it(column_list,out,n_bin,min_in_bin,smooth_bins,skip_covariance=False):

   from phenix.autosol.bayesian_estimator import bayesian_estimator
   from cctbx.array_family import flex 

   # create some training data. First value=target, rest are predictor variables
   first=True
   for line in open('raw_4_res.list').readlines():
     if first:
       first=False
       record_list=[]
       data_list=[]
       perfect_list=[]
     else:
       spl=line.split()[2:]
       values=[]
       for i in [0]+column_list:
         values.append(float(spl[i]))
       record_list.append(values)
       data_list.append(values[1:])
       perfect_list.append(values[0])
 
   run=bayesian_estimator(out=out,skip_covariance=skip_covariance,verbose=True)
   run.create_estimator(
         record_list=record_list,
         n_bin=n_bin,
         min_in_bin=min_in_bin,
         smooth_bins=smooth_bins,
         use_flat_y_dist=True 
          )

   # get the predicted values:
   predicted_data,predicted_sd_data=run.apply_estimator(data_list)


   f=open("out.dat","w")
   for perf,pred in zip (
         perfect_list,predicted_data):
      print >>f,perf,pred
   print "perf y, predicted y written to out.dat"

   c=flex.linear_correlation(flex.double(perfect_list),flex.double(predicted_data))
   print "CC: ",c.coefficient(),column_list
   return c.coefficient()

best_column_list=[]
best_cc=None
out=open('out.log','w')
"""
  1         2      3      4          5           6            7      8      9        10    11       12
CC_DENMOD RFACTOR SKEW NCS_OVERLAP NCS_COPIES NCS_IN_GROUP TRUNCATE REGIONS CONTRAST FOM FLATNESS CORR_RMS
"""
column_list=[3,12]
skip_covariance=True

for n_bin in [50]:
 for min_in_bin in [5]:
  for smooth_bins in [0]:
       try:
         print "TRY: ",n_bin,min_in_bin,smooth_bins,"...",
         sys.stdout.flush()
         cc=try_it(column_list,out,
         n_bin=n_bin,
         min_in_bin=min_in_bin,
         smooth_bins=smooth_bins,skip_covariance=skip_covariance)
         if  best_cc is None or cc>best_cc:
            best_cc=cc
            best_column_list=[n_bin,min_in_bin,smooth_bins]
            print "     New best cc: ",cc,best_column_list
            sys.stdout.flush()
       except:
         print "failed with ",column_list

 

