def try_it(column_list,out):

   from phenix.autosol.bayesian_estimator import bayesian_estimator
   from cctbx.array_family import flex 

   # create some training data. First value=target, rest are predictor variables
   first=True
   for line in open('raw_4_res.list').readlines():
     if first:
       first=False
       record_list=[]
       data_list=[]
       perfect_list=[]
     else:
       spl=line.split()[2:]
       values=[]
       for i in [0]+column_list:
         values.append(float(spl[i]))
       record_list.append(values)
       data_list.append(values[1:])
       perfect_list.append(values[0])
 
   run=bayesian_estimator(out=out)
   run.create_estimator(
         record_list=record_list,
         n_bin=30,
         min_in_bin=10,
         smooth_bins=6)

   # get the predicted values:
   predicted_data,predicted_sd_data=run.apply_estimator(data_list)


   f=open("out.dat","w")
   for perf,pred in zip (
         perfect_list,predicted_data):
      print >>f,perf,pred
   print "perf y, predicted y written to out.dat"

   c=flex.linear_correlation(flex.double(perfect_list),flex.double(predicted_data))
   print "CC: ",c.coefficient(),column_list
   return c.coefficient()

best_column_list=[]
best_cc=None
possible_columns=[1,2,3,4,5,6,7,8,9,10,11,12]
out=open('out.log','w')
while 1:
  best_new_column=None
  best_new_cc=None
  for c in possible_columns:
    if not c in best_column_list:
       column_list=best_column_list+[c]
       try:
         cc=try_it(column_list,out)
         if  best_new_cc is None or cc>best_new_cc:
            best_new_cc=cc
            best_new_column_list=column_list
            print "     New best local cc: ",cc,column_list
       except:
         print "failed with ",column_list

  if  best_cc is None or best_new_cc>best_cc:
     best_cc=best_new_cc
     best_column_list=best_new_column_list
     print "New best cc: ",best_new_cc,best_new_column_list
 

